﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace CrowdControl.Delegates.Metadata
{
    /// <summary> Attribute used to mark a method as metadata with the specified IDs.</summary>
    [AttributeUsage(AttributeTargets.Method)]
    public class MetadataAttribute : Attribute
    {
        /// <summary>
        /// Gets the IDs associated with the metadata.
        /// </summary>
        public string[] IDs { get; }

        public MetadataAttribute(string ids) : this(new[] { ids }) { }
    
        public MetadataAttribute(IEnumerable<string> ids) : this(ids.ToArray()) { }

        /// <summary> Attribute used to mark a method as metadata with the specified IDs.</summary>
        public MetadataAttribute(params string[] ids)
        {
            IDs = ids;
        }
    }
}